package LibArchive;

use 5.040001;
use strict;
use warnings;
use Carp;

require Exporter;
use AutoLoader;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use LibArchive ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	ARCHIVE_COMPRESSION_BZIP2
	ARCHIVE_COMPRESSION_COMPRESS
	ARCHIVE_COMPRESSION_GZIP
	ARCHIVE_COMPRESSION_LRZIP
	ARCHIVE_COMPRESSION_LZIP
	ARCHIVE_COMPRESSION_LZMA
	ARCHIVE_COMPRESSION_NONE
	ARCHIVE_COMPRESSION_PROGRAM
	ARCHIVE_COMPRESSION_RPM
	ARCHIVE_COMPRESSION_UU
	ARCHIVE_COMPRESSION_XZ
	ARCHIVE_ENTRY_ACL_ADD_FILE
	ARCHIVE_ENTRY_ACL_ADD_SUBDIRECTORY
	ARCHIVE_ENTRY_ACL_APPEND_DATA
	ARCHIVE_ENTRY_ACL_DELETE
	ARCHIVE_ENTRY_ACL_DELETE_CHILD
	ARCHIVE_ENTRY_ACL_ENTRY_DIRECTORY_INHERIT
	ARCHIVE_ENTRY_ACL_ENTRY_FAILED_ACCESS
	ARCHIVE_ENTRY_ACL_ENTRY_FILE_INHERIT
	ARCHIVE_ENTRY_ACL_ENTRY_INHERITED
	ARCHIVE_ENTRY_ACL_ENTRY_INHERIT_ONLY
	ARCHIVE_ENTRY_ACL_ENTRY_NO_PROPAGATE_INHERIT
	ARCHIVE_ENTRY_ACL_ENTRY_SUCCESSFUL_ACCESS
	ARCHIVE_ENTRY_ACL_EVERYONE
	ARCHIVE_ENTRY_ACL_EXECUTE
	ARCHIVE_ENTRY_ACL_GROUP
	ARCHIVE_ENTRY_ACL_GROUP_OBJ
	ARCHIVE_ENTRY_ACL_INHERITANCE_NFS4
	ARCHIVE_ENTRY_ACL_LIST_DIRECTORY
	ARCHIVE_ENTRY_ACL_MASK
	ARCHIVE_ENTRY_ACL_OTHER
	ARCHIVE_ENTRY_ACL_PERMS_NFS4
	ARCHIVE_ENTRY_ACL_PERMS_POSIX1E
	ARCHIVE_ENTRY_ACL_READ
	ARCHIVE_ENTRY_ACL_READ_ACL
	ARCHIVE_ENTRY_ACL_READ_ATTRIBUTES
	ARCHIVE_ENTRY_ACL_READ_DATA
	ARCHIVE_ENTRY_ACL_READ_NAMED_ATTRS
	ARCHIVE_ENTRY_ACL_STYLE_COMPACT
	ARCHIVE_ENTRY_ACL_STYLE_EXTRA_ID
	ARCHIVE_ENTRY_ACL_STYLE_MARK_DEFAULT
	ARCHIVE_ENTRY_ACL_STYLE_SEPARATOR_COMMA
	ARCHIVE_ENTRY_ACL_STYLE_SOLARIS
	ARCHIVE_ENTRY_ACL_SYNCHRONIZE
	ARCHIVE_ENTRY_ACL_TYPE_ACCESS
	ARCHIVE_ENTRY_ACL_TYPE_ALARM
	ARCHIVE_ENTRY_ACL_TYPE_ALLOW
	ARCHIVE_ENTRY_ACL_TYPE_AUDIT
	ARCHIVE_ENTRY_ACL_TYPE_DEFAULT
	ARCHIVE_ENTRY_ACL_TYPE_DENY
	ARCHIVE_ENTRY_ACL_TYPE_NFS4
	ARCHIVE_ENTRY_ACL_TYPE_POSIX1E
	ARCHIVE_ENTRY_ACL_USER
	ARCHIVE_ENTRY_ACL_USER_OBJ
	ARCHIVE_ENTRY_ACL_WRITE
	ARCHIVE_ENTRY_ACL_WRITE_ACL
	ARCHIVE_ENTRY_ACL_WRITE_ATTRIBUTES
	ARCHIVE_ENTRY_ACL_WRITE_DATA
	ARCHIVE_ENTRY_ACL_WRITE_NAMED_ATTRS
	ARCHIVE_ENTRY_ACL_WRITE_OWNER
	ARCHIVE_ENTRY_DIGEST_MD5
	ARCHIVE_ENTRY_DIGEST_RMD160
	ARCHIVE_ENTRY_DIGEST_SHA1
	ARCHIVE_ENTRY_DIGEST_SHA256
	ARCHIVE_ENTRY_DIGEST_SHA384
	ARCHIVE_ENTRY_DIGEST_SHA512
	ARCHIVE_EOF
	ARCHIVE_EXTRACT_ACL
	ARCHIVE_EXTRACT_CLEAR_NOCHANGE_FFLAGS
	ARCHIVE_EXTRACT_FFLAGS
	ARCHIVE_EXTRACT_HFS_COMPRESSION_FORCED
	ARCHIVE_EXTRACT_MAC_METADATA
	ARCHIVE_EXTRACT_NO_AUTODIR
	ARCHIVE_EXTRACT_NO_HFS_COMPRESSION
	ARCHIVE_EXTRACT_NO_OVERWRITE
	ARCHIVE_EXTRACT_NO_OVERWRITE_NEWER
	ARCHIVE_EXTRACT_OWNER
	ARCHIVE_EXTRACT_PERM
	ARCHIVE_EXTRACT_SAFE_WRITES
	ARCHIVE_EXTRACT_SECURE_NOABSOLUTEPATHS
	ARCHIVE_EXTRACT_SECURE_NODOTDOT
	ARCHIVE_EXTRACT_SECURE_SYMLINKS
	ARCHIVE_EXTRACT_SPARSE
	ARCHIVE_EXTRACT_TIME
	ARCHIVE_EXTRACT_UNLINK
	ARCHIVE_EXTRACT_XATTR
	ARCHIVE_FAILED
	ARCHIVE_FATAL
	ARCHIVE_FILTER_BZIP2
	ARCHIVE_FILTER_COMPRESS
	ARCHIVE_FILTER_GRZIP
	ARCHIVE_FILTER_GZIP
	ARCHIVE_FILTER_LRZIP
	ARCHIVE_FILTER_LZ4
	ARCHIVE_FILTER_LZIP
	ARCHIVE_FILTER_LZMA
	ARCHIVE_FILTER_LZOP
	ARCHIVE_FILTER_NONE
	ARCHIVE_FILTER_PROGRAM
	ARCHIVE_FILTER_RPM
	ARCHIVE_FILTER_UU
	ARCHIVE_FILTER_XZ
	ARCHIVE_FILTER_ZSTD
	ARCHIVE_FORMAT_7ZIP
	ARCHIVE_FORMAT_AR
	ARCHIVE_FORMAT_AR_BSD
	ARCHIVE_FORMAT_AR_GNU
	ARCHIVE_FORMAT_BASE_MASK
	ARCHIVE_FORMAT_CAB
	ARCHIVE_FORMAT_CPIO
	ARCHIVE_FORMAT_CPIO_AFIO_LARGE
	ARCHIVE_FORMAT_CPIO_BIN_BE
	ARCHIVE_FORMAT_CPIO_BIN_LE
	ARCHIVE_FORMAT_CPIO_POSIX
	ARCHIVE_FORMAT_CPIO_PWB
	ARCHIVE_FORMAT_CPIO_SVR4_CRC
	ARCHIVE_FORMAT_CPIO_SVR4_NOCRC
	ARCHIVE_FORMAT_EMPTY
	ARCHIVE_FORMAT_ISO9660
	ARCHIVE_FORMAT_ISO9660_ROCKRIDGE
	ARCHIVE_FORMAT_LHA
	ARCHIVE_FORMAT_MTREE
	ARCHIVE_FORMAT_RAR
	ARCHIVE_FORMAT_RAR_V5
	ARCHIVE_FORMAT_RAW
	ARCHIVE_FORMAT_SHAR
	ARCHIVE_FORMAT_SHAR_BASE
	ARCHIVE_FORMAT_SHAR_DUMP
	ARCHIVE_FORMAT_TAR
	ARCHIVE_FORMAT_TAR_GNUTAR
	ARCHIVE_FORMAT_TAR_PAX_INTERCHANGE
	ARCHIVE_FORMAT_TAR_PAX_RESTRICTED
	ARCHIVE_FORMAT_TAR_USTAR
	ARCHIVE_FORMAT_WARC
	ARCHIVE_FORMAT_XAR
	ARCHIVE_FORMAT_ZIP
	ARCHIVE_MATCH_CTIME
	ARCHIVE_MATCH_EQUAL
	ARCHIVE_MATCH_MTIME
	ARCHIVE_MATCH_NEWER
	ARCHIVE_MATCH_OLDER
	ARCHIVE_OK
	ARCHIVE_READDISK_HONOR_NODUMP
	ARCHIVE_READDISK_MAC_COPYFILE
	ARCHIVE_READDISK_NO_ACL
	ARCHIVE_READDISK_NO_FFLAGS
	ARCHIVE_READDISK_NO_SPARSE
	ARCHIVE_READDISK_NO_TRAVERSE_MOUNTS
	ARCHIVE_READDISK_NO_XATTR
	ARCHIVE_READDISK_RESTORE_ATIME
	ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_DATA
	ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_METADATA
	ARCHIVE_READ_FORMAT_CAPS_NONE
	ARCHIVE_READ_FORMAT_ENCRYPTION_DONT_KNOW
	ARCHIVE_READ_FORMAT_ENCRYPTION_UNSUPPORTED
	ARCHIVE_RETRY
	ARCHIVE_VERSION_NUMBER
	ARCHIVE_WARN
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	ARCHIVE_COMPRESSION_BZIP2
	ARCHIVE_COMPRESSION_COMPRESS
	ARCHIVE_COMPRESSION_GZIP
	ARCHIVE_COMPRESSION_LRZIP
	ARCHIVE_COMPRESSION_LZIP
	ARCHIVE_COMPRESSION_LZMA
	ARCHIVE_COMPRESSION_NONE
	ARCHIVE_COMPRESSION_PROGRAM
	ARCHIVE_COMPRESSION_RPM
	ARCHIVE_COMPRESSION_UU
	ARCHIVE_COMPRESSION_XZ
	ARCHIVE_ENTRY_ACL_ADD_FILE
	ARCHIVE_ENTRY_ACL_ADD_SUBDIRECTORY
	ARCHIVE_ENTRY_ACL_APPEND_DATA
	ARCHIVE_ENTRY_ACL_DELETE
	ARCHIVE_ENTRY_ACL_DELETE_CHILD
	ARCHIVE_ENTRY_ACL_ENTRY_DIRECTORY_INHERIT
	ARCHIVE_ENTRY_ACL_ENTRY_FAILED_ACCESS
	ARCHIVE_ENTRY_ACL_ENTRY_FILE_INHERIT
	ARCHIVE_ENTRY_ACL_ENTRY_INHERITED
	ARCHIVE_ENTRY_ACL_ENTRY_INHERIT_ONLY
	ARCHIVE_ENTRY_ACL_ENTRY_NO_PROPAGATE_INHERIT
	ARCHIVE_ENTRY_ACL_ENTRY_SUCCESSFUL_ACCESS
	ARCHIVE_ENTRY_ACL_EVERYONE
	ARCHIVE_ENTRY_ACL_EXECUTE
	ARCHIVE_ENTRY_ACL_GROUP
	ARCHIVE_ENTRY_ACL_GROUP_OBJ
	ARCHIVE_ENTRY_ACL_INHERITANCE_NFS4
	ARCHIVE_ENTRY_ACL_LIST_DIRECTORY
	ARCHIVE_ENTRY_ACL_MASK
	ARCHIVE_ENTRY_ACL_OTHER
	ARCHIVE_ENTRY_ACL_PERMS_NFS4
	ARCHIVE_ENTRY_ACL_PERMS_POSIX1E
	ARCHIVE_ENTRY_ACL_READ
	ARCHIVE_ENTRY_ACL_READ_ACL
	ARCHIVE_ENTRY_ACL_READ_ATTRIBUTES
	ARCHIVE_ENTRY_ACL_READ_DATA
	ARCHIVE_ENTRY_ACL_READ_NAMED_ATTRS
	ARCHIVE_ENTRY_ACL_STYLE_COMPACT
	ARCHIVE_ENTRY_ACL_STYLE_EXTRA_ID
	ARCHIVE_ENTRY_ACL_STYLE_MARK_DEFAULT
	ARCHIVE_ENTRY_ACL_STYLE_SEPARATOR_COMMA
	ARCHIVE_ENTRY_ACL_STYLE_SOLARIS
	ARCHIVE_ENTRY_ACL_SYNCHRONIZE
	ARCHIVE_ENTRY_ACL_TYPE_ACCESS
	ARCHIVE_ENTRY_ACL_TYPE_ALARM
	ARCHIVE_ENTRY_ACL_TYPE_ALLOW
	ARCHIVE_ENTRY_ACL_TYPE_AUDIT
	ARCHIVE_ENTRY_ACL_TYPE_DEFAULT
	ARCHIVE_ENTRY_ACL_TYPE_DENY
	ARCHIVE_ENTRY_ACL_TYPE_NFS4
	ARCHIVE_ENTRY_ACL_TYPE_POSIX1E
	ARCHIVE_ENTRY_ACL_USER
	ARCHIVE_ENTRY_ACL_USER_OBJ
	ARCHIVE_ENTRY_ACL_WRITE
	ARCHIVE_ENTRY_ACL_WRITE_ACL
	ARCHIVE_ENTRY_ACL_WRITE_ATTRIBUTES
	ARCHIVE_ENTRY_ACL_WRITE_DATA
	ARCHIVE_ENTRY_ACL_WRITE_NAMED_ATTRS
	ARCHIVE_ENTRY_ACL_WRITE_OWNER
	ARCHIVE_ENTRY_DIGEST_MD5
	ARCHIVE_ENTRY_DIGEST_RMD160
	ARCHIVE_ENTRY_DIGEST_SHA1
	ARCHIVE_ENTRY_DIGEST_SHA256
	ARCHIVE_ENTRY_DIGEST_SHA384
	ARCHIVE_ENTRY_DIGEST_SHA512
	ARCHIVE_EOF
	ARCHIVE_EXTRACT_ACL
	ARCHIVE_EXTRACT_CLEAR_NOCHANGE_FFLAGS
	ARCHIVE_EXTRACT_FFLAGS
	ARCHIVE_EXTRACT_HFS_COMPRESSION_FORCED
	ARCHIVE_EXTRACT_MAC_METADATA
	ARCHIVE_EXTRACT_NO_AUTODIR
	ARCHIVE_EXTRACT_NO_HFS_COMPRESSION
	ARCHIVE_EXTRACT_NO_OVERWRITE
	ARCHIVE_EXTRACT_NO_OVERWRITE_NEWER
	ARCHIVE_EXTRACT_OWNER
	ARCHIVE_EXTRACT_PERM
	ARCHIVE_EXTRACT_SAFE_WRITES
	ARCHIVE_EXTRACT_SECURE_NOABSOLUTEPATHS
	ARCHIVE_EXTRACT_SECURE_NODOTDOT
	ARCHIVE_EXTRACT_SECURE_SYMLINKS
	ARCHIVE_EXTRACT_SPARSE
	ARCHIVE_EXTRACT_TIME
	ARCHIVE_EXTRACT_UNLINK
	ARCHIVE_EXTRACT_XATTR
	ARCHIVE_FAILED
	ARCHIVE_FATAL
	ARCHIVE_FILTER_BZIP2
	ARCHIVE_FILTER_COMPRESS
	ARCHIVE_FILTER_GRZIP
	ARCHIVE_FILTER_GZIP
	ARCHIVE_FILTER_LRZIP
	ARCHIVE_FILTER_LZ4
	ARCHIVE_FILTER_LZIP
	ARCHIVE_FILTER_LZMA
	ARCHIVE_FILTER_LZOP
	ARCHIVE_FILTER_NONE
	ARCHIVE_FILTER_PROGRAM
	ARCHIVE_FILTER_RPM
	ARCHIVE_FILTER_UU
	ARCHIVE_FILTER_XZ
	ARCHIVE_FILTER_ZSTD
	ARCHIVE_FORMAT_7ZIP
	ARCHIVE_FORMAT_AR
	ARCHIVE_FORMAT_AR_BSD
	ARCHIVE_FORMAT_AR_GNU
	ARCHIVE_FORMAT_BASE_MASK
	ARCHIVE_FORMAT_CAB
	ARCHIVE_FORMAT_CPIO
	ARCHIVE_FORMAT_CPIO_AFIO_LARGE
	ARCHIVE_FORMAT_CPIO_BIN_BE
	ARCHIVE_FORMAT_CPIO_BIN_LE
	ARCHIVE_FORMAT_CPIO_POSIX
	ARCHIVE_FORMAT_CPIO_PWB
	ARCHIVE_FORMAT_CPIO_SVR4_CRC
	ARCHIVE_FORMAT_CPIO_SVR4_NOCRC
	ARCHIVE_FORMAT_EMPTY
	ARCHIVE_FORMAT_ISO9660
	ARCHIVE_FORMAT_ISO9660_ROCKRIDGE
	ARCHIVE_FORMAT_LHA
	ARCHIVE_FORMAT_MTREE
	ARCHIVE_FORMAT_RAR
	ARCHIVE_FORMAT_RAR_V5
	ARCHIVE_FORMAT_RAW
	ARCHIVE_FORMAT_SHAR
	ARCHIVE_FORMAT_SHAR_BASE
	ARCHIVE_FORMAT_SHAR_DUMP
	ARCHIVE_FORMAT_TAR
	ARCHIVE_FORMAT_TAR_GNUTAR
	ARCHIVE_FORMAT_TAR_PAX_INTERCHANGE
	ARCHIVE_FORMAT_TAR_PAX_RESTRICTED
	ARCHIVE_FORMAT_TAR_USTAR
	ARCHIVE_FORMAT_WARC
	ARCHIVE_FORMAT_XAR
	ARCHIVE_FORMAT_ZIP
	ARCHIVE_MATCH_CTIME
	ARCHIVE_MATCH_EQUAL
	ARCHIVE_MATCH_MTIME
	ARCHIVE_MATCH_NEWER
	ARCHIVE_MATCH_OLDER
	ARCHIVE_OK
	ARCHIVE_READDISK_HONOR_NODUMP
	ARCHIVE_READDISK_MAC_COPYFILE
	ARCHIVE_READDISK_NO_ACL
	ARCHIVE_READDISK_NO_FFLAGS
	ARCHIVE_READDISK_NO_SPARSE
	ARCHIVE_READDISK_NO_TRAVERSE_MOUNTS
	ARCHIVE_READDISK_NO_XATTR
	ARCHIVE_READDISK_RESTORE_ATIME
	ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_DATA
	ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_METADATA
	ARCHIVE_READ_FORMAT_CAPS_NONE
	ARCHIVE_READ_FORMAT_ENCRYPTION_DONT_KNOW
	ARCHIVE_READ_FORMAT_ENCRYPTION_UNSUPPORTED
	ARCHIVE_RETRY
	ARCHIVE_VERSION_NUMBER
	ARCHIVE_WARN
);

our $VERSION = '3.7.4';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "&LibArchive::constant not defined" if $constname eq 'constant';
    my ($error, $val) = constant($constname);
    if ($error) { croak $error; }
    {
	no strict 'refs';
	# Fixed between 5.005_53 and 5.005_61
#XXX	if ($] >= 5.00561) {
#XXX	    *$AUTOLOAD = sub () { $val };
#XXX	}
#XXX	else {
	    *$AUTOLOAD = sub { $val };
#XXX	}
    }
    goto &$AUTOLOAD;
}

require XSLoader;
XSLoader::load('LibArchive', $VERSION);

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

LibArchive - Perl extension to access libarchive functions

=head1 SYNOPSIS

  use LibArchive;

=head1 DESCRIPTION

We currently support only a limited interface for reading archives.

=head2 EXPORT

None by default.

=head2 Exportable constants

  ARCHIVE_COMPRESSION_BZIP2
  ARCHIVE_COMPRESSION_COMPRESS
  ARCHIVE_COMPRESSION_GZIP
  ARCHIVE_COMPRESSION_LRZIP
  ARCHIVE_COMPRESSION_LZIP
  ARCHIVE_COMPRESSION_LZMA
  ARCHIVE_COMPRESSION_NONE
  ARCHIVE_COMPRESSION_PROGRAM
  ARCHIVE_COMPRESSION_RPM
  ARCHIVE_COMPRESSION_UU
  ARCHIVE_COMPRESSION_XZ
  ARCHIVE_ENTRY_ACL_ADD_FILE
  ARCHIVE_ENTRY_ACL_ADD_SUBDIRECTORY
  ARCHIVE_ENTRY_ACL_APPEND_DATA
  ARCHIVE_ENTRY_ACL_DELETE
  ARCHIVE_ENTRY_ACL_DELETE_CHILD
  ARCHIVE_ENTRY_ACL_ENTRY_DIRECTORY_INHERIT
  ARCHIVE_ENTRY_ACL_ENTRY_FAILED_ACCESS
  ARCHIVE_ENTRY_ACL_ENTRY_FILE_INHERIT
  ARCHIVE_ENTRY_ACL_ENTRY_INHERITED
  ARCHIVE_ENTRY_ACL_ENTRY_INHERIT_ONLY
  ARCHIVE_ENTRY_ACL_ENTRY_NO_PROPAGATE_INHERIT
  ARCHIVE_ENTRY_ACL_ENTRY_SUCCESSFUL_ACCESS
  ARCHIVE_ENTRY_ACL_EVERYONE
  ARCHIVE_ENTRY_ACL_EXECUTE
  ARCHIVE_ENTRY_ACL_GROUP
  ARCHIVE_ENTRY_ACL_GROUP_OBJ
  ARCHIVE_ENTRY_ACL_INHERITANCE_NFS4
  ARCHIVE_ENTRY_ACL_LIST_DIRECTORY
  ARCHIVE_ENTRY_ACL_MASK
  ARCHIVE_ENTRY_ACL_OTHER
  ARCHIVE_ENTRY_ACL_PERMS_NFS4
  ARCHIVE_ENTRY_ACL_PERMS_POSIX1E
  ARCHIVE_ENTRY_ACL_READ
  ARCHIVE_ENTRY_ACL_READ_ACL
  ARCHIVE_ENTRY_ACL_READ_ATTRIBUTES
  ARCHIVE_ENTRY_ACL_READ_DATA
  ARCHIVE_ENTRY_ACL_READ_NAMED_ATTRS
  ARCHIVE_ENTRY_ACL_STYLE_COMPACT
  ARCHIVE_ENTRY_ACL_STYLE_EXTRA_ID
  ARCHIVE_ENTRY_ACL_STYLE_MARK_DEFAULT
  ARCHIVE_ENTRY_ACL_STYLE_SEPARATOR_COMMA
  ARCHIVE_ENTRY_ACL_STYLE_SOLARIS
  ARCHIVE_ENTRY_ACL_SYNCHRONIZE
  ARCHIVE_ENTRY_ACL_TYPE_ACCESS
  ARCHIVE_ENTRY_ACL_TYPE_ALARM
  ARCHIVE_ENTRY_ACL_TYPE_ALLOW
  ARCHIVE_ENTRY_ACL_TYPE_AUDIT
  ARCHIVE_ENTRY_ACL_TYPE_DEFAULT
  ARCHIVE_ENTRY_ACL_TYPE_DENY
  ARCHIVE_ENTRY_ACL_TYPE_NFS4
  ARCHIVE_ENTRY_ACL_TYPE_POSIX1E
  ARCHIVE_ENTRY_ACL_USER
  ARCHIVE_ENTRY_ACL_USER_OBJ
  ARCHIVE_ENTRY_ACL_WRITE
  ARCHIVE_ENTRY_ACL_WRITE_ACL
  ARCHIVE_ENTRY_ACL_WRITE_ATTRIBUTES
  ARCHIVE_ENTRY_ACL_WRITE_DATA
  ARCHIVE_ENTRY_ACL_WRITE_NAMED_ATTRS
  ARCHIVE_ENTRY_ACL_WRITE_OWNER
  ARCHIVE_ENTRY_DIGEST_MD5
  ARCHIVE_ENTRY_DIGEST_RMD160
  ARCHIVE_ENTRY_DIGEST_SHA1
  ARCHIVE_ENTRY_DIGEST_SHA256
  ARCHIVE_ENTRY_DIGEST_SHA384
  ARCHIVE_ENTRY_DIGEST_SHA512
  ARCHIVE_EOF
  ARCHIVE_EXTRACT_ACL
  ARCHIVE_EXTRACT_CLEAR_NOCHANGE_FFLAGS
  ARCHIVE_EXTRACT_FFLAGS
  ARCHIVE_EXTRACT_HFS_COMPRESSION_FORCED
  ARCHIVE_EXTRACT_MAC_METADATA
  ARCHIVE_EXTRACT_NO_AUTODIR
  ARCHIVE_EXTRACT_NO_HFS_COMPRESSION
  ARCHIVE_EXTRACT_NO_OVERWRITE
  ARCHIVE_EXTRACT_NO_OVERWRITE_NEWER
  ARCHIVE_EXTRACT_OWNER
  ARCHIVE_EXTRACT_PERM
  ARCHIVE_EXTRACT_SAFE_WRITES
  ARCHIVE_EXTRACT_SECURE_NOABSOLUTEPATHS
  ARCHIVE_EXTRACT_SECURE_NODOTDOT
  ARCHIVE_EXTRACT_SECURE_SYMLINKS
  ARCHIVE_EXTRACT_SPARSE
  ARCHIVE_EXTRACT_TIME
  ARCHIVE_EXTRACT_UNLINK
  ARCHIVE_EXTRACT_XATTR
  ARCHIVE_FAILED
  ARCHIVE_FATAL
  ARCHIVE_FILTER_BZIP2
  ARCHIVE_FILTER_COMPRESS
  ARCHIVE_FILTER_GRZIP
  ARCHIVE_FILTER_GZIP
  ARCHIVE_FILTER_LRZIP
  ARCHIVE_FILTER_LZ4
  ARCHIVE_FILTER_LZIP
  ARCHIVE_FILTER_LZMA
  ARCHIVE_FILTER_LZOP
  ARCHIVE_FILTER_NONE
  ARCHIVE_FILTER_PROGRAM
  ARCHIVE_FILTER_RPM
  ARCHIVE_FILTER_UU
  ARCHIVE_FILTER_XZ
  ARCHIVE_FILTER_ZSTD
  ARCHIVE_FORMAT_7ZIP
  ARCHIVE_FORMAT_AR
  ARCHIVE_FORMAT_AR_BSD
  ARCHIVE_FORMAT_AR_GNU
  ARCHIVE_FORMAT_BASE_MASK
  ARCHIVE_FORMAT_CAB
  ARCHIVE_FORMAT_CPIO
  ARCHIVE_FORMAT_CPIO_AFIO_LARGE
  ARCHIVE_FORMAT_CPIO_BIN_BE
  ARCHIVE_FORMAT_CPIO_BIN_LE
  ARCHIVE_FORMAT_CPIO_POSIX
  ARCHIVE_FORMAT_CPIO_PWB
  ARCHIVE_FORMAT_CPIO_SVR4_CRC
  ARCHIVE_FORMAT_CPIO_SVR4_NOCRC
  ARCHIVE_FORMAT_EMPTY
  ARCHIVE_FORMAT_ISO9660
  ARCHIVE_FORMAT_ISO9660_ROCKRIDGE
  ARCHIVE_FORMAT_LHA
  ARCHIVE_FORMAT_MTREE
  ARCHIVE_FORMAT_RAR
  ARCHIVE_FORMAT_RAR_V5
  ARCHIVE_FORMAT_RAW
  ARCHIVE_FORMAT_SHAR
  ARCHIVE_FORMAT_SHAR_BASE
  ARCHIVE_FORMAT_SHAR_DUMP
  ARCHIVE_FORMAT_TAR
  ARCHIVE_FORMAT_TAR_GNUTAR
  ARCHIVE_FORMAT_TAR_PAX_INTERCHANGE
  ARCHIVE_FORMAT_TAR_PAX_RESTRICTED
  ARCHIVE_FORMAT_TAR_USTAR
  ARCHIVE_FORMAT_WARC
  ARCHIVE_FORMAT_XAR
  ARCHIVE_FORMAT_ZIP
  ARCHIVE_MATCH_CTIME
  ARCHIVE_MATCH_EQUAL
  ARCHIVE_MATCH_MTIME
  ARCHIVE_MATCH_NEWER
  ARCHIVE_MATCH_OLDER
  ARCHIVE_OK
  ARCHIVE_READDISK_HONOR_NODUMP
  ARCHIVE_READDISK_MAC_COPYFILE
  ARCHIVE_READDISK_NO_ACL
  ARCHIVE_READDISK_NO_FFLAGS
  ARCHIVE_READDISK_NO_SPARSE
  ARCHIVE_READDISK_NO_TRAVERSE_MOUNTS
  ARCHIVE_READDISK_NO_XATTR
  ARCHIVE_READDISK_RESTORE_ATIME
  ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_DATA
  ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_METADATA
  ARCHIVE_READ_FORMAT_CAPS_NONE
  ARCHIVE_READ_FORMAT_ENCRYPTION_DONT_KNOW
  ARCHIVE_READ_FORMAT_ENCRYPTION_UNSUPPORTED
  ARCHIVE_RETRY
  ARCHIVE_VERSION_NUMBER
  ARCHIVE_WARN



=head1 SEE ALSO

  man libarchive

=head1 AUTHOR

perl bindings: Proxmox Support Team, E<lt>support@proxmox.comE<gt>

libarchive: Tim Kientzle

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007-2025 Proxmox Server Solutions GmbH <support@proxmox.com>

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU Affero General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License along
with this program. If not, see <https://www.gnu.org/licenses/>.

=cut
