var __defProp = Object.defineProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// dist/snippets/proxmox-yew-comp-95c5221b38cb059a/js-helper-module.js
var js_helper_module_exports = {};
__export(js_helper_module_exports, {
  async_sleep: () => async_sleep,
  clear_auth_cookie: () => clear_auth_cookie,
  get_cookie: () => get_cookie,
  set_cookie: () => set_cookie
});
function async_sleep(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}
function set_cookie(value) {
  document.cookie = value;
}
function clear_auth_cookie(name) {
  document.cookie = name + "=; expires=Thu, 01-Jan-1970 00:00:01 GMT; SameSite=Lax;";
}
function get_cookie() {
  return document.cookie;
}

// dist/snippets/pwt-8941b8bd3d4d7445/js-helper-module.js
var js_helper_module_exports2 = {};
__export(js_helper_module_exports2, {
  close_dialog: () => close_dialog,
  hide_popover: () => hide_popover,
  show_dialog: () => show_dialog,
  show_modal_dialog: () => show_modal_dialog,
  show_popover: () => show_popover,
  test_alert: () => test_alert,
  toggle_popover: () => toggle_popover
});
function test_alert() {
  alert("This is a test!");
}
function show_modal_dialog(dialog) {
  dialog.showModal();
  dialog.setAttribute("aria-modal", "true");
}
function show_dialog(dialog) {
  dialog.show();
  dialog.setAttribute("aria-modal", "false");
}
function close_dialog(dialog) {
  dialog.close();
  dialog.removeAttribute("aria-modal");
}
function hide_popover(popover) {
  popover.hidePopover();
}
function show_popover(popover) {
  popover.showPopover();
}
function toggle_popover(popover) {
  popover.togglePopover();
}

// dist/pmg-mobile-quarantine-ui.js
var wasm;
function isLikeNone(x) {
  return x === void 0 || x === null;
}
function addToExternrefTable0(obj) {
  const idx = wasm.__externref_table_alloc();
  wasm.__wbindgen_export_1.set(idx, obj);
  return idx;
}
var cachedTextDecoder = typeof TextDecoder !== "undefined" ? new TextDecoder("utf-8", { ignoreBOM: true, fatal: true }) : { decode: () => {
  throw Error("TextDecoder not available");
} };
if (typeof TextDecoder !== "undefined") {
  cachedTextDecoder.decode();
}
var cachedUint8ArrayMemory0 = null;
function getUint8ArrayMemory0() {
  if (cachedUint8ArrayMemory0 === null || cachedUint8ArrayMemory0.byteLength === 0) {
    cachedUint8ArrayMemory0 = new Uint8Array(wasm.memory.buffer);
  }
  return cachedUint8ArrayMemory0;
}
function getStringFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return cachedTextDecoder.decode(getUint8ArrayMemory0().subarray(ptr, ptr + len));
}
function handleError(f, args) {
  try {
    return f.apply(this, args);
  } catch (e) {
    const idx = addToExternrefTable0(e);
    wasm.__wbindgen_exn_store(idx);
  }
}
var WASM_VECTOR_LEN = 0;
var cachedTextEncoder = typeof TextEncoder !== "undefined" ? new TextEncoder("utf-8") : { encode: () => {
  throw Error("TextEncoder not available");
} };
var encodeString = typeof cachedTextEncoder.encodeInto === "function" ? function(arg, view) {
  return cachedTextEncoder.encodeInto(arg, view);
} : function(arg, view) {
  const buf = cachedTextEncoder.encode(arg);
  view.set(buf);
  return {
    read: arg.length,
    written: buf.length
  };
};
function passStringToWasm0(arg, malloc, realloc) {
  if (realloc === void 0) {
    const buf = cachedTextEncoder.encode(arg);
    const ptr2 = malloc(buf.length, 1) >>> 0;
    getUint8ArrayMemory0().subarray(ptr2, ptr2 + buf.length).set(buf);
    WASM_VECTOR_LEN = buf.length;
    return ptr2;
  }
  let len = arg.length;
  let ptr = malloc(len, 1) >>> 0;
  const mem = getUint8ArrayMemory0();
  let offset = 0;
  for (; offset < len; offset++) {
    const code = arg.charCodeAt(offset);
    if (code > 127) break;
    mem[ptr + offset] = code;
  }
  if (offset !== len) {
    if (offset !== 0) {
      arg = arg.slice(offset);
    }
    ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
    const view = getUint8ArrayMemory0().subarray(ptr + offset, ptr + len);
    const ret = encodeString(arg, view);
    offset += ret.written;
    ptr = realloc(ptr, len, offset, 1) >>> 0;
  }
  WASM_VECTOR_LEN = offset;
  return ptr;
}
var cachedDataViewMemory0 = null;
function getDataViewMemory0() {
  if (cachedDataViewMemory0 === null || cachedDataViewMemory0.buffer.detached === true || cachedDataViewMemory0.buffer.detached === void 0 && cachedDataViewMemory0.buffer !== wasm.memory.buffer) {
    cachedDataViewMemory0 = new DataView(wasm.memory.buffer);
  }
  return cachedDataViewMemory0;
}
function getArrayJsValueFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  const mem = getDataViewMemory0();
  const result = [];
  for (let i = ptr; i < ptr + 4 * len; i += 4) {
    result.push(wasm.__wbindgen_export_1.get(mem.getUint32(i, true)));
  }
  wasm.__externref_drop_slice(ptr, len);
  return result;
}
var CLOSURE_DTORS = typeof FinalizationRegistry === "undefined" ? { register: () => {
}, unregister: () => {
} } : new FinalizationRegistry((state) => {
  wasm.__wbindgen_export_7.get(state.dtor)(state.a, state.b);
});
function makeMutClosure(arg0, arg1, dtor, f) {
  const state = { a: arg0, b: arg1, cnt: 1, dtor };
  const real = (...args) => {
    state.cnt++;
    const a = state.a;
    state.a = 0;
    try {
      return f(a, state.b, ...args);
    } finally {
      if (--state.cnt === 0) {
        wasm.__wbindgen_export_7.get(state.dtor)(a, state.b);
        CLOSURE_DTORS.unregister(state);
      } else {
        state.a = a;
      }
    }
  };
  real.original = state;
  CLOSURE_DTORS.register(real, state, state);
  return real;
}
function makeClosure(arg0, arg1, dtor, f) {
  const state = { a: arg0, b: arg1, cnt: 1, dtor };
  const real = (...args) => {
    state.cnt++;
    try {
      return f(state.a, state.b, ...args);
    } finally {
      if (--state.cnt === 0) {
        wasm.__wbindgen_export_7.get(state.dtor)(state.a, state.b);
        state.a = 0;
        CLOSURE_DTORS.unregister(state);
      }
    }
  };
  real.original = state;
  CLOSURE_DTORS.register(real, state, state);
  return real;
}
function debugString(val) {
  const type = typeof val;
  if (type == "number" || type == "boolean" || val == null) {
    return `${val}`;
  }
  if (type == "string") {
    return `"${val}"`;
  }
  if (type == "symbol") {
    const description = val.description;
    if (description == null) {
      return "Symbol";
    } else {
      return `Symbol(${description})`;
    }
  }
  if (type == "function") {
    const name = val.name;
    if (typeof name == "string" && name.length > 0) {
      return `Function(${name})`;
    } else {
      return "Function";
    }
  }
  if (Array.isArray(val)) {
    const length = val.length;
    let debug = "[";
    if (length > 0) {
      debug += debugString(val[0]);
    }
    for (let i = 1; i < length; i++) {
      debug += ", " + debugString(val[i]);
    }
    debug += "]";
    return debug;
  }
  const builtInMatches = /\[object ([^\]]+)\]/.exec(toString.call(val));
  let className;
  if (builtInMatches && builtInMatches.length > 1) {
    className = builtInMatches[1];
  } else {
    return toString.call(val);
  }
  if (className == "Object") {
    try {
      return "Object(" + JSON.stringify(val) + ")";
    } catch (_) {
      return "Object";
    }
  }
  if (val instanceof Error) {
    return `${val.name}: ${val.message}
${val.stack}`;
  }
  return className;
}
function __wbg_adapter_40(arg0, arg1, arg2) {
  wasm.closure37_externref_shim(arg0, arg1, arg2);
}
function __wbg_adapter_45(arg0, arg1) {
  wasm._dyn_core__ops__function__FnMut_____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__invoke__h00e662400da01175(arg0, arg1);
}
function __wbg_adapter_48(arg0, arg1) {
  wasm._dyn_core__ops__function__Fn_____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__invoke__h502c9f8b6e2b9827(arg0, arg1);
}
function passArrayJsValueToWasm0(array, malloc) {
  const ptr = malloc(array.length * 4, 4) >>> 0;
  const mem = getDataViewMemory0();
  for (let i = 0; i < array.length; i++) {
    mem.setUint32(ptr + 4 * i, addToExternrefTable0(array[i]), true);
  }
  WASM_VECTOR_LEN = array.length;
  return ptr;
}
function __wbg_adapter_51(arg0, arg1, arg2) {
  const ptr0 = passArrayJsValueToWasm0(arg2, wasm.__wbindgen_malloc);
  const len0 = WASM_VECTOR_LEN;
  wasm._dyn_core__ops__function__Fn__A____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__invoke__hb5454d89c8fcbb09(arg0, arg1, ptr0, len0);
}
function __wbg_adapter_54(arg0, arg1, arg2) {
  wasm.closure128_externref_shim(arg0, arg1, arg2);
}
function __wbg_adapter_57(arg0, arg1, arg2) {
  wasm.closure136_externref_shim(arg0, arg1, arg2);
}
async function __wbg_load(module, imports) {
  if (typeof Response === "function" && module instanceof Response) {
    if (typeof WebAssembly.instantiateStreaming === "function") {
      try {
        return await WebAssembly.instantiateStreaming(module, imports);
      } catch (e) {
        if (module.headers.get("Content-Type") != "application/wasm") {
          console.warn("`WebAssembly.instantiateStreaming` failed because your server does not serve Wasm with `application/wasm` MIME type. Falling back to `WebAssembly.instantiate` which is slower. Original error:\n", e);
        } else {
          throw e;
        }
      }
    }
    const bytes = await module.arrayBuffer();
    return await WebAssembly.instantiate(bytes, imports);
  } else {
    const instance = await WebAssembly.instantiate(module, imports);
    if (instance instanceof WebAssembly.Instance) {
      return { instance, module };
    } else {
      return instance;
    }
  }
}
function __wbg_get_imports() {
  const imports = {};
  imports.wbg = {};
  imports.wbg.__wbg_abort_f3886488090e9bc4 = function(arg0) {
    arg0.abort();
  };
  imports.wbg.__wbg_activeElement_e98911690df61cbc = function(arg0) {
    const ret = arg0.activeElement;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_addEventListener_5b61a93d4093f065 = function() {
    return handleError(function(arg0, arg1, arg2, arg3) {
      arg0.addEventListener(getStringFromWasm0(arg1, arg2), arg3);
    }, arguments);
  };
  imports.wbg.__wbg_addEventListener_821b3cb329c60b16 = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4) {
      arg0.addEventListener(getStringFromWasm0(arg1, arg2), arg3, arg4);
    }, arguments);
  };
  imports.wbg.__wbg_add_87855f9f0deeffba = function() {
    return handleError(function(arg0, arg1, arg2) {
      arg0.add(getStringFromWasm0(arg1, arg2));
    }, arguments);
  };
  imports.wbg.__wbg_append_44f47251e73c32f7 = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4) {
      arg0.append(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
    }, arguments);
  };
  imports.wbg.__wbg_arrayBuffer_2cd3115a5d95f6ee = function() {
    return handleError(function(arg0) {
      const ret = arg0.arrayBuffer();
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_blur_0bdaeaf39a72195f = function() {
    return handleError(function(arg0) {
      arg0.blur();
    }, arguments);
  };
  imports.wbg.__wbg_body_829806af8ac11f62 = function(arg0) {
    const ret = arg0.body;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_bottom_a9c638ca4a280dba = function(arg0) {
    const ret = arg0.bottom;
    return ret;
  };
  imports.wbg.__wbg_bubbles_3c7581a34b959a5d = function(arg0) {
    const ret = arg0.bubbles;
    return ret;
  };
  imports.wbg.__wbg_buffer_ef9774282e5dab94 = function(arg0) {
    const ret = arg0.buffer;
    return ret;
  };
  imports.wbg.__wbg_button_e1202b6a207f008c = function(arg0) {
    const ret = arg0.button;
    return ret;
  };
  imports.wbg.__wbg_cachekey_57601dac16343711 = function(arg0) {
    const ret = arg0.__yew_subtree_cache_key;
    return isLikeNone(ret) ? 4294967297 : ret >>> 0;
  };
  imports.wbg.__wbg_call_0ad083564791763a = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg0.call(arg1);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_cancelBubble_d31e709d108c7e09 = function(arg0) {
    const ret = arg0.cancelBubble;
    return ret;
  };
  imports.wbg.__wbg_changedTouches_6e45a6cde5b234bd = function(arg0) {
    const ret = arg0.changedTouches;
    return ret;
  };
  imports.wbg.__wbg_childNodes_86c1f7c957c54607 = function(arg0) {
    const ret = arg0.childNodes;
    return ret;
  };
  imports.wbg.__wbg_children_9928355b7d11ac16 = function(arg0) {
    const ret = arg0.children;
    return ret;
  };
  imports.wbg.__wbg_classList_2785f439ab0ea923 = function(arg0) {
    const ret = arg0.classList;
    return ret;
  };
  imports.wbg.__wbg_clearTimeout_5a54f8841c30079a = function(arg0) {
    const ret = clearTimeout(arg0);
    return ret;
  };
  imports.wbg.__wbg_clearauthcookie_e38e0553010cc45c = function(arg0, arg1) {
    clear_auth_cookie(getStringFromWasm0(arg0, arg1));
  };
  imports.wbg.__wbg_clientHeight_399a8661468efd17 = function(arg0) {
    const ret = arg0.clientHeight;
    return ret;
  };
  imports.wbg.__wbg_clientLeft_69660706b8392d61 = function(arg0) {
    const ret = arg0.clientLeft;
    return ret;
  };
  imports.wbg.__wbg_clientTop_e5f0dc38dc79dfbf = function(arg0) {
    const ret = arg0.clientTop;
    return ret;
  };
  imports.wbg.__wbg_clientWidth_0fae5997458ca3e6 = function(arg0) {
    const ret = arg0.clientWidth;
    return ret;
  };
  imports.wbg.__wbg_clientX_3f292f799cdfc934 = function(arg0) {
    const ret = arg0.clientX;
    return ret;
  };
  imports.wbg.__wbg_clientX_bfdd92e5077c5e2a = function(arg0) {
    const ret = arg0.clientX;
    return ret;
  };
  imports.wbg.__wbg_clientY_0491ec2415c4edc8 = function(arg0) {
    const ret = arg0.clientY;
    return ret;
  };
  imports.wbg.__wbg_clientY_b81c30920e55e8ed = function(arg0) {
    const ret = arg0.clientY;
    return ret;
  };
  imports.wbg.__wbg_cloneNode_e422f8429e206e0c = function() {
    return handleError(function(arg0) {
      const ret = arg0.cloneNode();
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_code_9178315ce7de6df4 = function(arg0, arg1) {
    const ret = arg1.code;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_composedPath_5e778b8ba685a2a7 = function(arg0) {
    const ret = arg0.composedPath();
    return ret;
  };
  imports.wbg.__wbg_contains_14b9011e4f5f44b0 = function(arg0, arg1) {
    const ret = arg0.contains(arg1);
    return ret;
  };
  imports.wbg.__wbg_contains_84217d1de38d2d5b = function(arg0, arg1, arg2) {
    const ret = arg0.contains(getStringFromWasm0(arg1, arg2));
    return ret;
  };
  imports.wbg.__wbg_createElementNS_7fb22e52467f488a = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4) {
      const ret = arg0.createElementNS(arg1 === 0 ? void 0 : getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_createElement_0089172505b8c33d = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = arg0.createElement(getStringFromWasm0(arg1, arg2));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_createTextNode_f3c93918cab5ea43 = function(arg0, arg1, arg2) {
    const ret = arg0.createTextNode(getStringFromWasm0(arg1, arg2));
    return ret;
  };
  imports.wbg.__wbg_credentials_7ec41876b96e76f5 = function(arg0) {
    const ret = arg0.credentials;
    return ret;
  };
  imports.wbg.__wbg_ctrlKey_117dc6f71d52f2e3 = function(arg0) {
    const ret = arg0.ctrlKey;
    return ret;
  };
  imports.wbg.__wbg_ctrlKey_397d1305a9d8e110 = function(arg0) {
    const ret = arg0.ctrlKey;
    return ret;
  };
  imports.wbg.__wbg_debug_b6964170b3e87b13 = function(arg0, arg1, arg2, arg3) {
    console.debug(arg0, arg1, arg2, arg3);
  };
  imports.wbg.__wbg_deltaY_3526a54e54c36036 = function(arg0) {
    const ret = arg0.deltaY;
    return ret;
  };
  imports.wbg.__wbg_disconnect_5cbea743522be9da = function(arg0) {
    arg0.disconnect();
  };
  imports.wbg.__wbg_dispatchEvent_ad86175b6670e823 = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg0.dispatchEvent(arg1);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_documentElement_565d9c8ba6d7837a = function(arg0) {
    const ret = arg0.documentElement;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_document_73c992534351cdee = function(arg0) {
    const ret = arg0.document;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_entries_83beb641792ccb9c = function(arg0) {
    const ret = Object.entries(arg0);
    return ret;
  };
  imports.wbg.__wbg_error_0aa52a01e6e7818f = function(arg0) {
    console.error(arg0);
  };
  imports.wbg.__wbg_error_3c7d958458bf649b = function(arg0, arg1) {
    var v0 = getArrayJsValueFromWasm0(arg0, arg1).slice();
    wasm.__wbindgen_free(arg0, arg1 * 4, 4);
    console.error(...v0);
  };
  imports.wbg.__wbg_error_7534b8e9a36f1ab4 = function(arg0, arg1) {
    let deferred0_0;
    let deferred0_1;
    try {
      deferred0_0 = arg0;
      deferred0_1 = arg1;
      console.error(getStringFromWasm0(arg0, arg1));
    } finally {
      wasm.__wbindgen_free(deferred0_0, deferred0_1, 1);
    }
  };
  imports.wbg.__wbg_error_e5dc0d8246d4270a = function(arg0, arg1, arg2, arg3) {
    console.error(arg0, arg1, arg2, arg3);
  };
  imports.wbg.__wbg_fetch_67bf08bc29702652 = function(arg0, arg1) {
    const ret = arg0.fetch(arg1);
    return ret;
  };
  imports.wbg.__wbg_fetch_f9746204cce9509b = function(arg0, arg1, arg2) {
    const ret = arg0.fetch(arg1, arg2);
    return ret;
  };
  imports.wbg.__wbg_focus_cbac3489d3e2ebac = function() {
    return handleError(function(arg0) {
      arg0.focus();
    }, arguments);
  };
  imports.wbg.__wbg_from_3aa0fcaa8eef0104 = function(arg0) {
    const ret = Array.from(arg0);
    return ret;
  };
  imports.wbg.__wbg_getAttribute_3500281a3412eff8 = function(arg0, arg1, arg2, arg3) {
    const ret = arg1.getAttribute(getStringFromWasm0(arg2, arg3));
    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_getBoundingClientRect_2be673d622047ae1 = function(arg0) {
    const ret = arg0.getBoundingClientRect();
    return ret;
  };
  imports.wbg.__wbg_getComputedStyle_efcd172cbf9437df = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg0.getComputedStyle(arg1);
      return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
    }, arguments);
  };
  imports.wbg.__wbg_getDate_be2a89a16e766eb6 = function(arg0) {
    const ret = arg0.getDate();
    return ret;
  };
  imports.wbg.__wbg_getElementById_f8652c4d7eb3a8f4 = function(arg0, arg1, arg2) {
    const ret = arg0.getElementById(getStringFromWasm0(arg1, arg2));
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_getElementsByTagName_c0942d35f8394b46 = function(arg0, arg1, arg2) {
    const ret = arg0.getElementsByTagName(getStringFromWasm0(arg1, arg2));
    return ret;
  };
  imports.wbg.__wbg_getFullYear_f085d10495856d3d = function(arg0) {
    const ret = arg0.getFullYear();
    return ret;
  };
  imports.wbg.__wbg_getItem_64706cda4cce3eb1 = function() {
    return handleError(function(arg0, arg1, arg2, arg3) {
      const ret = arg1.getItem(getStringFromWasm0(arg2, arg3));
      var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      var len1 = WASM_VECTOR_LEN;
      getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
    }, arguments);
  };
  imports.wbg.__wbg_getMonth_63484d13ef71e192 = function(arg0) {
    const ret = arg0.getMonth();
    return ret;
  };
  imports.wbg.__wbg_getPropertyValue_8a2aa1580b27a567 = function() {
    return handleError(function(arg0, arg1, arg2, arg3) {
      const ret = arg1.getPropertyValue(getStringFromWasm0(arg2, arg3));
      const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN;
      getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
    }, arguments);
  };
  imports.wbg.__wbg_getTime_6953b8a865af729b = function(arg0) {
    const ret = arg0.getTime();
    return ret;
  };
  imports.wbg.__wbg_get_0c3cc364764a0b98 = function(arg0, arg1) {
    const ret = arg0[arg1 >>> 0];
    return ret;
  };
  imports.wbg.__wbg_get_51f049a42640d5dc = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg0.get(arg1);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_get_6d1ed8da50bbcb3d = function(arg0, arg1, arg2, arg3) {
    const ret = arg1.get(getStringFromWasm0(arg2, arg3));
    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_get_93975e840d4936d5 = function(arg0, arg1) {
    const ret = arg0[arg1 >>> 0];
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_get_b996a12be035ef4f = function() {
    return handleError(function(arg0, arg1) {
      const ret = Reflect.get(arg0, arg1);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_get_f0a4da5ed0283f46 = function() {
    return handleError(function(arg0, arg1, arg2, arg3) {
      const ret = arg1.get(getStringFromWasm0(arg2, arg3));
      var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      var len1 = WASM_VECTOR_LEN;
      getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
    }, arguments);
  };
  imports.wbg.__wbg_getcookie_9a85554aaa9b336f = function(arg0) {
    const ret = get_cookie();
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_getwithindex_da91543d7eb44abf = function(arg0, arg1) {
    const ret = arg0[arg1 >>> 0];
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_getwithrefkey_6550b2c093d2eb18 = function(arg0, arg1) {
    const ret = arg0[arg1];
    return ret;
  };
  imports.wbg.__wbg_globalThis_6b4d52a0b6aaeaea = function() {
    return handleError(function() {
      const ret = globalThis.globalThis;
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_global_49324ce12193de77 = function() {
    return handleError(function() {
      const ret = global.global;
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_go_a43e406d96449549 = function() {
    return handleError(function(arg0, arg1) {
      arg0.go(arg1);
    }, arguments);
  };
  imports.wbg.__wbg_hasAttribute_8a32ff6c2727e50a = function(arg0, arg1, arg2) {
    const ret = arg0.hasAttribute(getStringFromWasm0(arg1, arg2));
    return ret;
  };
  imports.wbg.__wbg_hasOwnProperty_11a57990e90693e9 = function(arg0, arg1) {
    const ret = arg0.hasOwnProperty(arg1);
    return ret;
  };
  imports.wbg.__wbg_hash_8eaa3d39e87db6c4 = function(arg0, arg1) {
    const ret = arg1.hash;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_hash_da0067190c2e8ee6 = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg1.hash;
      const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN;
      getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
    }, arguments);
  };
  imports.wbg.__wbg_headers_7d91888acd10dd7b = function(arg0) {
    const ret = arg0.headers;
    return ret;
  };
  imports.wbg.__wbg_headers_a56c7a1056dceb4d = function(arg0) {
    const ret = arg0.headers;
    return ret;
  };
  imports.wbg.__wbg_height_081676f0882bdbe1 = function(arg0) {
    const ret = arg0.height;
    return ret;
  };
  imports.wbg.__wbg_history_3ee00dcb235510c7 = function() {
    return handleError(function(arg0) {
      const ret = arg0.history;
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_host_deaac02b3d2f71ad = function(arg0) {
    const ret = arg0.host;
    return ret;
  };
  imports.wbg.__wbg_href_09e6ca6355b170a5 = function(arg0, arg1) {
    const ret = arg1.href;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_href_fbdb6d6f9b284c1c = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg1.href;
      const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN;
      getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
    }, arguments);
  };
  imports.wbg.__wbg_id_05360791b76deac6 = function(arg0, arg1) {
    const ret = arg1.id;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_identifier_e6aefa1d6833ab2b = function(arg0) {
    const ret = arg0.identifier;
    return ret;
  };
  imports.wbg.__wbg_indexOf_752d784e5b12bd58 = function(arg0, arg1, arg2) {
    const ret = arg0.indexOf(arg1, arg2);
    return ret;
  };
  imports.wbg.__wbg_info_e19142e7f34f3101 = function(arg0, arg1, arg2, arg3) {
    console.info(arg0, arg1, arg2, arg3);
  };
  imports.wbg.__wbg_innerHeight_7aec8c41b5cd9004 = function() {
    return handleError(function(arg0) {
      const ret = arg0.innerHeight;
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_innerWidth_7ae8ed14426ced60 = function() {
    return handleError(function(arg0) {
      const ret = arg0.innerWidth;
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_insertBefore_afe67ccd5514f8a3 = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = arg0.insertBefore(arg1, arg2);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_instanceof_ArrayBuffer_ff40e55b5978e215 = function(arg0) {
    let result;
    try {
      result = arg0 instanceof ArrayBuffer;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_Element_bd74ec70f1c8363f = function(arg0) {
    let result;
    try {
      result = arg0 instanceof Element;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_Error_0c9a394fe7dece82 = function(arg0) {
    let result;
    try {
      result = arg0 instanceof Error;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_HtmlElement_f1383839e0c98321 = function(arg0) {
    let result;
    try {
      result = arg0 instanceof HTMLElement;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_Node_d1d1e1da02e92dc2 = function(arg0) {
    let result;
    try {
      result = arg0 instanceof Node;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_PointerEvent_fcef0f6dbc5e98bf = function(arg0) {
    let result;
    try {
      result = arg0 instanceof PointerEvent;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_ShadowRoot_4bb5417d03d94ed3 = function(arg0) {
    let result;
    try {
      result = arg0 instanceof ShadowRoot;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_Uint8Array_db97368f94b1373f = function(arg0) {
    let result;
    try {
      result = arg0 instanceof Uint8Array;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_instanceof_Window_b6121c2f80910d3f = function(arg0) {
    let result;
    try {
      result = arg0 instanceof Window;
    } catch (_) {
      result = false;
    }
    const ret = result;
    return ret;
  };
  imports.wbg.__wbg_isArray_8738f1062fa88586 = function(arg0) {
    const ret = Array.isArray(arg0);
    return ret;
  };
  imports.wbg.__wbg_isContentEditable_3dc9f817687425c0 = function(arg0) {
    const ret = arg0.isContentEditable;
    return ret;
  };
  imports.wbg.__wbg_isSafeInteger_a1b3e0811faecf2f = function(arg0) {
    const ret = Number.isSafeInteger(arg0);
    return ret;
  };
  imports.wbg.__wbg_is_d6c5f207fac5a36c = function(arg0, arg1) {
    const ret = Object.is(arg0, arg1);
    return ret;
  };
  imports.wbg.__wbg_item_a1dceba424f5426a = function(arg0, arg1) {
    const ret = arg0.item(arg1 >>> 0);
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_key_b26a394622fb7c58 = function(arg0, arg1) {
    const ret = arg1.key;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_lastChild_d552b02f52781458 = function(arg0) {
    const ret = arg0.lastChild;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_left_9b1b566565918001 = function(arg0) {
    const ret = arg0.left;
    return ret;
  };
  imports.wbg.__wbg_length_12246a78d2f65d3a = function(arg0) {
    const ret = arg0.length;
    return ret;
  };
  imports.wbg.__wbg_length_7626010b7db74fa7 = function(arg0) {
    const ret = arg0.length;
    return ret;
  };
  imports.wbg.__wbg_length_c24da17096edfe57 = function(arg0) {
    const ret = arg0.length;
    return ret;
  };
  imports.wbg.__wbg_length_d5a30d85f5b55935 = function(arg0) {
    const ret = arg0.length;
    return ret;
  };
  imports.wbg.__wbg_listenerid_ed1678830a5b97ec = function(arg0) {
    const ret = arg0.__yew_listener_id;
    return isLikeNone(ret) ? 4294967297 : ret >>> 0;
  };
  imports.wbg.__wbg_localStorage_cd757a65a18add59 = function() {
    return handleError(function(arg0) {
      const ret = arg0.localStorage;
      return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
    }, arguments);
  };
  imports.wbg.__wbg_location_861fdd81803e86e9 = function(arg0) {
    const ret = arg0.location;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_location_e065dfe2478de244 = function(arg0) {
    const ret = arg0.location;
    return ret;
  };
  imports.wbg.__wbg_log_8ebee8c18566458b = function(arg0, arg1, arg2, arg3) {
    console.log(arg0, arg1, arg2, arg3);
  };
  imports.wbg.__wbg_matchMedia_7c16917c0b7a0fa9 = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = arg0.matchMedia(getStringFromWasm0(arg1, arg2));
      return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
    }, arguments);
  };
  imports.wbg.__wbg_matches_276dbc35e9f8531d = function(arg0) {
    const ret = arg0.matches;
    return ret;
  };
  imports.wbg.__wbg_message_6b6d81e3ec937f34 = function(arg0) {
    const ret = arg0.message;
    return ret;
  };
  imports.wbg.__wbg_namespaceURI_d6c1d1223d106030 = function(arg0, arg1) {
    const ret = arg1.namespaceURI;
    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_navigator_d1748b0a3de45763 = function(arg0) {
    const ret = arg0.navigator;
    return ret;
  };
  imports.wbg.__wbg_new0_fe1554a5ea9b2468 = function() {
    const ret = /* @__PURE__ */ new Date();
    return ret;
  };
  imports.wbg.__wbg_new_246469fac0121a8d = function() {
    return handleError(function(arg0, arg1) {
      const ret = new Event(getStringFromWasm0(arg0, arg1));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_new_532d74b0c04719ba = function() {
    return handleError(function() {
      const ret = new AbortController();
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_new_59845962d1127937 = function(arg0) {
    const ret = new Uint8Array(arg0);
    return ret;
  };
  imports.wbg.__wbg_new_67abf4a77618ee3e = function() {
    const ret = new Object();
    return ret;
  };
  imports.wbg.__wbg_new_6ac2a82ee00370b2 = function(arg0, arg1) {
    const ret = new Error(getStringFromWasm0(arg0, arg1));
    return ret;
  };
  imports.wbg.__wbg_new_89c48e135005d11e = function() {
    return handleError(function(arg0) {
      const ret = new ResizeObserver(arg0);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_new_8a6f238a6ece86ea = function() {
    const ret = new Error();
    return ret;
  };
  imports.wbg.__wbg_new_a4be66957af3f104 = function() {
    return handleError(function() {
      const ret = new URLSearchParams();
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_new_a96f21efc59c18b1 = function(arg0) {
    const ret = new Date(arg0);
    return ret;
  };
  imports.wbg.__wbg_new_d81bc6e110208061 = function() {
    return handleError(function() {
      const ret = new Headers();
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_new_f63f9c5cd8dc1ec5 = function() {
    return handleError(function(arg0, arg1) {
      const ret = new URL(getStringFromWasm0(arg0, arg1));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_newnoargs_a136448eeb7d48ac = function(arg0, arg1) {
    const ret = new Function(getStringFromWasm0(arg0, arg1));
    return ret;
  };
  imports.wbg.__wbg_newwithbase_b66002cdeafe80f5 = function() {
    return handleError(function(arg0, arg1, arg2, arg3) {
      const ret = new URL(getStringFromWasm0(arg0, arg1), getStringFromWasm0(arg2, arg3));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_newwithbyteoffsetandlength_84908302a4c137cf = function(arg0, arg1, arg2) {
    const ret = new Uint8Array(arg0, arg1 >>> 0, arg2 >>> 0);
    return ret;
  };
  imports.wbg.__wbg_newwithlength_4c216eaaf23f2f9a = function(arg0) {
    const ret = new Uint8Array(arg0 >>> 0);
    return ret;
  };
  imports.wbg.__wbg_newwithstr_6651b103aab39591 = function() {
    return handleError(function(arg0, arg1) {
      const ret = new URLSearchParams(getStringFromWasm0(arg0, arg1));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_newwithstrandinit_fd498779e66280a6 = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = new Request(getStringFromWasm0(arg0, arg1), arg2);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_nextSibling_3a27e8181cbd801b = function(arg0) {
    const ret = arg0.nextSibling;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_nodeName_38a0ed0a4919802c = function(arg0, arg1) {
    const ret = arg1.nodeName;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_now_c58794884eef001c = function() {
    const ret = Date.now();
    return ret;
  };
  imports.wbg.__wbg_observe_3efb30e396185adc = function(arg0, arg1) {
    arg0.observe(arg1);
  };
  imports.wbg.__wbg_observe_433a1421acef83ec = function(arg0, arg1, arg2) {
    arg0.observe(arg1, arg2);
  };
  imports.wbg.__wbg_offsetWidth_eed4c2052f6314c0 = function(arg0) {
    const ret = arg0.offsetWidth;
    return ret;
  };
  imports.wbg.__wbg_ok_d9c0949018a8715b = function(arg0) {
    const ret = arg0.ok;
    return ret;
  };
  imports.wbg.__wbg_parentElement_65de729e671c380e = function(arg0) {
    const ret = arg0.parentElement;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_parentNode_2f73bb1b71bcfd4b = function(arg0) {
    const ret = arg0.parentNode;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_parse_bd09af51fd7dd576 = function() {
    return handleError(function(arg0, arg1) {
      const ret = JSON.parse(getStringFromWasm0(arg0, arg1));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_parse_bff2b04295ab8774 = function(arg0, arg1) {
    const ret = Date.parse(getStringFromWasm0(arg0, arg1));
    return ret;
  };
  imports.wbg.__wbg_pathname_7df9a58558255a4f = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg1.pathname;
      const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN;
      getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
    }, arguments);
  };
  imports.wbg.__wbg_pathname_9a9c181ddd90af31 = function(arg0, arg1) {
    const ret = arg1.pathname;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_pointerId_c2ead2ca06e75c11 = function(arg0) {
    const ret = arg0.pointerId;
    return ret;
  };
  imports.wbg.__wbg_pointerType_7b9198fef7d9f091 = function(arg0, arg1) {
    const ret = arg1.pointerType;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_preventDefault_c57f0065c644067c = function(arg0) {
    arg0.preventDefault();
  };
  imports.wbg.__wbg_pushState_5c062586065d21bd = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4, arg5) {
      arg0.pushState(arg1, getStringFromWasm0(arg2, arg3), arg4 === 0 ? void 0 : getStringFromWasm0(arg4, arg5));
    }, arguments);
  };
  imports.wbg.__wbg_querySelectorAll_4bf43d4845ebfaee = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = arg0.querySelectorAll(getStringFromWasm0(arg1, arg2));
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_querySelector_0c2a611162173f7f = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = arg0.querySelector(getStringFromWasm0(arg1, arg2));
      return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
    }, arguments);
  };
  imports.wbg.__wbg_relatedTarget_1402367cd9abcb5c = function(arg0) {
    const ret = arg0.relatedTarget;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_removeAttribute_9cd1896f15d71d8a = function() {
    return handleError(function(arg0, arg1, arg2) {
      arg0.removeAttribute(getStringFromWasm0(arg1, arg2));
    }, arguments);
  };
  imports.wbg.__wbg_removeChild_a2ba837a405e0360 = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg0.removeChild(arg1);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_removeEventListener_a0ca044299e2a2e3 = function() {
    return handleError(function(arg0, arg1, arg2, arg3) {
      arg0.removeEventListener(getStringFromWasm0(arg1, arg2), arg3);
    }, arguments);
  };
  imports.wbg.__wbg_removeEventListener_cc55816336837519 = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4) {
      arg0.removeEventListener(getStringFromWasm0(arg1, arg2), arg3, arg4 !== 0);
    }, arguments);
  };
  imports.wbg.__wbg_removeProperty_90e5079c1e0ba966 = function() {
    return handleError(function(arg0, arg1, arg2, arg3) {
      const ret = arg1.removeProperty(getStringFromWasm0(arg2, arg3));
      const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN;
      getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
    }, arguments);
  };
  imports.wbg.__wbg_remove_2f38e78b91a3e792 = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4, arg5, arg6) {
      arg0.remove(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4), getStringFromWasm0(arg5, arg6));
    }, arguments);
  };
  imports.wbg.__wbg_remove_3ffbd4a2f54aee48 = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4) {
      arg0.remove(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
    }, arguments);
  };
  imports.wbg.__wbg_replaceState_c9ce6c938d995932 = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4, arg5) {
      arg0.replaceState(arg1, getStringFromWasm0(arg2, arg3), arg4 === 0 ? void 0 : getStringFromWasm0(arg4, arg5));
    }, arguments);
  };
  imports.wbg.__wbg_replace_8d95817d95fa6919 = function() {
    return handleError(function(arg0, arg1, arg2) {
      arg0.replace(getStringFromWasm0(arg1, arg2));
    }, arguments);
  };
  imports.wbg.__wbg_resolve_267ff08e7e1d2ce4 = function(arg0) {
    const ret = Promise.resolve(arg0);
    return ret;
  };
  imports.wbg.__wbg_right_cb7112ef3a82ed83 = function(arg0) {
    const ret = arg0.right;
    return ret;
  };
  imports.wbg.__wbg_scrollHeight_fa9c1fbe7c1a3d53 = function(arg0) {
    const ret = arg0.scrollHeight;
    return ret;
  };
  imports.wbg.__wbg_scrollLeft_f65cd4cb73227c64 = function(arg0) {
    const ret = arg0.scrollLeft;
    return ret;
  };
  imports.wbg.__wbg_scrollTop_461051bbcef2c6cc = function(arg0) {
    const ret = arg0.scrollTop;
    return ret;
  };
  imports.wbg.__wbg_scrollTop_7c8e987b2ec6be5e = function(arg0) {
    const ret = arg0.scrollTop;
    return ret;
  };
  imports.wbg.__wbg_scrollWidth_d1c392472a866273 = function(arg0) {
    const ret = arg0.scrollWidth;
    return ret;
  };
  imports.wbg.__wbg_search_2a3003fb772d3e72 = function(arg0, arg1) {
    const ret = arg1.search;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_search_563434b654cbaafe = function() {
    return handleError(function(arg0, arg1) {
      const ret = arg1.search;
      const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
      const len1 = WASM_VECTOR_LEN;
      getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
      getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
    }, arguments);
  };
  imports.wbg.__wbg_self_cca3ca60d61220f4 = function() {
    return handleError(function() {
      const ret = self.self;
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_sessionStorage_bae32d862702cfeb = function() {
    return handleError(function(arg0) {
      const ret = arg0.sessionStorage;
      return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
    }, arguments);
  };
  imports.wbg.__wbg_setAttribute_08124c686d4293da = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4) {
      arg0.setAttribute(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
    }, arguments);
  };
  imports.wbg.__wbg_setHours_19279c3ee40588e9 = function(arg0, arg1) {
    const ret = arg0.setHours(arg1 >>> 0);
    return ret;
  };
  imports.wbg.__wbg_setItem_0767c4315a9e5739 = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4) {
      arg0.setItem(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
    }, arguments);
  };
  imports.wbg.__wbg_setMilliseconds_01c383cf94bc6845 = function(arg0, arg1) {
    const ret = arg0.setMilliseconds(arg1 >>> 0);
    return ret;
  };
  imports.wbg.__wbg_setMinutes_792d486b966e0e17 = function(arg0, arg1) {
    const ret = arg0.setMinutes(arg1 >>> 0);
    return ret;
  };
  imports.wbg.__wbg_setPointerCapture_7d3d6716ddc1f12f = function() {
    return handleError(function(arg0, arg1) {
      arg0.setPointerCapture(arg1);
    }, arguments);
  };
  imports.wbg.__wbg_setProperty_570e68574d6d2ff5 = function() {
    return handleError(function(arg0, arg1, arg2, arg3, arg4) {
      arg0.setProperty(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
    }, arguments);
  };
  imports.wbg.__wbg_setSeconds_3dca9c7a4bd4bffc = function(arg0, arg1) {
    const ret = arg0.setSeconds(arg1 >>> 0);
    return ret;
  };
  imports.wbg.__wbg_setTimeout_db2dbaeefb6f39c7 = function() {
    return handleError(function(arg0, arg1) {
      const ret = setTimeout(arg0, arg1);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_set_1b50d2de855a9d50 = function() {
    return handleError(function(arg0, arg1, arg2) {
      const ret = Reflect.set(arg0, arg1, arg2);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_set_3807d5f0bfc24aa7 = function(arg0, arg1, arg2) {
    arg0[arg1] = arg2;
  };
  imports.wbg.__wbg_set_5deee49b10b2b780 = function(arg0, arg1, arg2) {
    arg0.set(arg1, arg2 >>> 0);
  };
  imports.wbg.__wbg_set_709fa1150f78e32d = function(arg0, arg1, arg2, arg3, arg4) {
    arg0.set(getStringFromWasm0(arg1, arg2), getStringFromWasm0(arg3, arg4));
  };
  imports.wbg.__wbg_setcachekey_bb5f908a0e3ee714 = function(arg0, arg1) {
    arg0.__yew_subtree_cache_key = arg1 >>> 0;
  };
  imports.wbg.__wbg_setchecked_496b6ba209abfe1b = function(arg0, arg1) {
    arg0.checked = arg1 !== 0;
  };
  imports.wbg.__wbg_setcookie_a290708235a6b294 = function(arg0, arg1) {
    set_cookie(getStringFromWasm0(arg0, arg1));
  };
  imports.wbg.__wbg_sethash_f0238e09aee2f9ac = function(arg0, arg1, arg2) {
    arg0.hash = getStringFromWasm0(arg1, arg2);
  };
  imports.wbg.__wbg_setinnerHTML_c902e26c750ab739 = function(arg0, arg1, arg2) {
    arg0.innerHTML = getStringFromWasm0(arg1, arg2);
  };
  imports.wbg.__wbg_setlistenerid_3d14d37a42484593 = function(arg0, arg1) {
    arg0.__yew_listener_id = arg1 >>> 0;
  };
  imports.wbg.__wbg_setnodeValue_65d9363c62331186 = function(arg0, arg1, arg2) {
    arg0.nodeValue = arg1 === 0 ? void 0 : getStringFromWasm0(arg1, arg2);
  };
  imports.wbg.__wbg_setscrollLeft_3ef6af1fde8daecf = function(arg0, arg1) {
    arg0.scrollLeft = arg1;
  };
  imports.wbg.__wbg_setscrollTop_6bce4e9685a5794a = function(arg0, arg1) {
    arg0.scrollTop = arg1;
  };
  imports.wbg.__wbg_setsearch_6d36c55702c70a1d = function() {
    return handleError(function(arg0, arg1, arg2) {
      arg0.search = getStringFromWasm0(arg1, arg2);
    }, arguments);
  };
  imports.wbg.__wbg_setsubtreeid_32b8ceff55862e29 = function(arg0, arg1) {
    arg0.__yew_subtree_id = arg1 >>> 0;
  };
  imports.wbg.__wbg_settabIndex_b773b2b7108b65cc = function(arg0, arg1) {
    arg0.tabIndex = arg1;
  };
  imports.wbg.__wbg_setvalue_369edd4f6ef17f3f = function(arg0, arg1, arg2) {
    arg0.value = getStringFromWasm0(arg1, arg2);
  };
  imports.wbg.__wbg_setvalue_fed536284ad1baec = function(arg0, arg1, arg2) {
    arg0.value = getStringFromWasm0(arg1, arg2);
  };
  imports.wbg.__wbg_shiftKey_0d5e334a8be6fe5a = function(arg0) {
    const ret = arg0.shiftKey;
    return ret;
  };
  imports.wbg.__wbg_shiftKey_7898fbf5189df96a = function(arg0) {
    const ret = arg0.shiftKey;
    return ret;
  };
  imports.wbg.__wbg_signal_5c364bb221dd7ca1 = function(arg0) {
    const ret = arg0.signal;
    return ret;
  };
  imports.wbg.__wbg_stack_0ed75d68575b0f3c = function(arg0, arg1) {
    const ret = arg1.stack;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_state_12ee9ee793174f3a = function() {
    return handleError(function(arg0) {
      const ret = arg0.state;
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_statusText_dcfea97efe017c18 = function(arg0, arg1) {
    const ret = arg1.statusText;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_status_01a4aa44f69c566a = function(arg0) {
    const ret = arg0.status;
    return ret;
  };
  imports.wbg.__wbg_stopPropagation_6c87871ab8a8a42b = function(arg0) {
    arg0.stopPropagation();
  };
  imports.wbg.__wbg_stringify_841980d1bf485619 = function() {
    return handleError(function(arg0) {
      const ret = JSON.stringify(arg0);
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_style_209b67559d8012e9 = function(arg0) {
    const ret = arg0.style;
    return ret;
  };
  imports.wbg.__wbg_subtreeid_e65dfcc52d403fd9 = function(arg0) {
    const ret = arg0.__yew_subtree_id;
    return isLikeNone(ret) ? 4294967297 : ret >>> 0;
  };
  imports.wbg.__wbg_tagName_9add0b1362497a50 = function(arg0, arg1) {
    const ret = arg1.tagName;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_target_1b60539ef57b9dd3 = function(arg0) {
    const ret = arg0.target;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_target_366a733e6b2c660b = function(arg0) {
    const ret = arg0.target;
    return isLikeNone(ret) ? 0 : addToExternrefTable0(ret);
  };
  imports.wbg.__wbg_target_bb95ca66b195fc0c = function(arg0) {
    const ret = arg0.target;
    return ret;
  };
  imports.wbg.__wbg_text_4aa1b4bc0625eff5 = function() {
    return handleError(function(arg0) {
      const ret = arg0.text();
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_then_84907e7a6730461e = function(arg0, arg1) {
    const ret = arg0.then(arg1);
    return ret;
  };
  imports.wbg.__wbg_then_db12746ab6cec3f6 = function(arg0, arg1, arg2) {
    const ret = arg0.then(arg1, arg2);
    return ret;
  };
  imports.wbg.__wbg_toString_2a965b6fc5a7e89f = function(arg0) {
    const ret = arg0.toString();
    return ret;
  };
  imports.wbg.__wbg_toString_5eb859e9871e175f = function(arg0) {
    const ret = arg0.toString();
    return ret;
  };
  imports.wbg.__wbg_top_e16b0ad8d66f398b = function(arg0) {
    const ret = arg0.top;
    return ret;
  };
  imports.wbg.__wbg_touches_9329fb7c2ddbd125 = function(arg0) {
    const ret = arg0.touches;
    return ret;
  };
  imports.wbg.__wbg_value_73546ced7943e234 = function(arg0, arg1) {
    const ret = arg1.value;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_value_f860f07b72ab53b8 = function(arg0, arg1) {
    const ret = arg1.value;
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbg_warn_c2df9e71b9d2797a = function(arg0, arg1, arg2, arg3) {
    console.warn(arg0, arg1, arg2, arg3);
  };
  imports.wbg.__wbg_width_3ecdf09bd704210c = function(arg0) {
    const ret = arg0.width;
    return ret;
  };
  imports.wbg.__wbg_window_2aba046d3fc4ad7c = function() {
    return handleError(function() {
      const ret = window.window;
      return ret;
    }, arguments);
  };
  imports.wbg.__wbg_x_58cce31b9b51c5f9 = function(arg0) {
    const ret = arg0.x;
    return ret;
  };
  imports.wbg.__wbg_x_b688fab8486605d0 = function(arg0) {
    const ret = arg0.x;
    return ret;
  };
  imports.wbg.__wbg_y_1d2000fd8c3ac8b9 = function(arg0) {
    const ret = arg0.y;
    return ret;
  };
  imports.wbg.__wbg_y_71ae0a29d22f6295 = function(arg0) {
    const ret = arg0.y;
    return ret;
  };
  imports.wbg.__wbindgen_boolean_get = function(arg0) {
    const v = arg0;
    const ret = typeof v === "boolean" ? v ? 1 : 0 : 2;
    return ret;
  };
  imports.wbg.__wbindgen_cb_drop = function(arg0) {
    const obj = arg0.original;
    if (obj.cnt-- == 1) {
      obj.a = 0;
      return true;
    }
    const ret = false;
    return ret;
  };
  imports.wbg.__wbindgen_closure_wrapper1308 = function(arg0, arg1, arg2) {
    const ret = makeMutClosure(arg0, arg1, 38, __wbg_adapter_40);
    return ret;
  };
  imports.wbg.__wbindgen_closure_wrapper1321 = function(arg0, arg1, arg2) {
    const ret = makeMutClosure(arg0, arg1, 38, __wbg_adapter_40);
    return ret;
  };
  imports.wbg.__wbindgen_closure_wrapper1357 = function(arg0, arg1, arg2) {
    const ret = makeMutClosure(arg0, arg1, 38, __wbg_adapter_45);
    return ret;
  };
  imports.wbg.__wbindgen_closure_wrapper2641 = function(arg0, arg1, arg2) {
    const ret = makeClosure(arg0, arg1, 38, __wbg_adapter_48);
    return ret;
  };
  imports.wbg.__wbindgen_closure_wrapper3376 = function(arg0, arg1, arg2) {
    const ret = makeClosure(arg0, arg1, 38, __wbg_adapter_51);
    return ret;
  };
  imports.wbg.__wbindgen_closure_wrapper5621 = function(arg0, arg1, arg2) {
    const ret = makeMutClosure(arg0, arg1, 38, __wbg_adapter_54);
    return ret;
  };
  imports.wbg.__wbindgen_closure_wrapper6613 = function(arg0, arg1, arg2) {
    const ret = makeClosure(arg0, arg1, 38, __wbg_adapter_57);
    return ret;
  };
  imports.wbg.__wbindgen_debug_string = function(arg0, arg1) {
    const ret = debugString(arg1);
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbindgen_error_new = function(arg0, arg1) {
    const ret = new Error(getStringFromWasm0(arg0, arg1));
    return ret;
  };
  imports.wbg.__wbindgen_in = function(arg0, arg1) {
    const ret = arg0 in arg1;
    return ret;
  };
  imports.wbg.__wbindgen_init_externref_table = function() {
    const table = wasm.__wbindgen_export_1;
    const offset = table.grow(4);
    table.set(0, void 0);
    table.set(offset + 0, void 0);
    table.set(offset + 1, null);
    table.set(offset + 2, true);
    table.set(offset + 3, false);
    ;
  };
  imports.wbg.__wbindgen_is_object = function(arg0) {
    const val = arg0;
    const ret = typeof val === "object" && val !== null;
    return ret;
  };
  imports.wbg.__wbindgen_is_string = function(arg0) {
    const ret = typeof arg0 === "string";
    return ret;
  };
  imports.wbg.__wbindgen_is_undefined = function(arg0) {
    const ret = arg0 === void 0;
    return ret;
  };
  imports.wbg.__wbindgen_jsval_eq = function(arg0, arg1) {
    const ret = arg0 === arg1;
    return ret;
  };
  imports.wbg.__wbindgen_jsval_loose_eq = function(arg0, arg1) {
    const ret = arg0 == arg1;
    return ret;
  };
  imports.wbg.__wbindgen_memory = function() {
    const ret = wasm.memory;
    return ret;
  };
  imports.wbg.__wbindgen_number_get = function(arg0, arg1) {
    const obj = arg1;
    const ret = typeof obj === "number" ? obj : void 0;
    getDataViewMemory0().setFloat64(arg0 + 8 * 1, isLikeNone(ret) ? 0 : ret, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, !isLikeNone(ret), true);
  };
  imports.wbg.__wbindgen_number_new = function(arg0) {
    const ret = arg0;
    return ret;
  };
  imports.wbg.__wbindgen_string_get = function(arg0, arg1) {
    const obj = arg1;
    const ret = typeof obj === "string" ? obj : void 0;
    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
  };
  imports.wbg.__wbindgen_string_new = function(arg0, arg1) {
    const ret = getStringFromWasm0(arg0, arg1);
    return ret;
  };
  imports.wbg.__wbindgen_throw = function(arg0, arg1) {
    throw new Error(getStringFromWasm0(arg0, arg1));
  };
  imports["./snippets/proxmox-yew-comp-95c5221b38cb059a/js-helper-module.js"] = js_helper_module_exports;
  imports["./snippets/pwt-8941b8bd3d4d7445/js-helper-module.js"] = js_helper_module_exports2;
  return imports;
}
function __wbg_init_memory(imports, memory) {
}
function __wbg_finalize_init(instance, module) {
  wasm = instance.exports;
  __wbg_init.__wbindgen_wasm_module = module;
  cachedDataViewMemory0 = null;
  cachedUint8ArrayMemory0 = null;
  wasm.__wbindgen_start();
  return wasm;
}
function initSync(module) {
  if (wasm !== void 0) return wasm;
  if (typeof module !== "undefined") {
    if (Object.getPrototypeOf(module) === Object.prototype) {
      ({ module } = module);
    } else {
      console.warn("using deprecated parameters for `initSync()`; pass a single object instead");
    }
  }
  const imports = __wbg_get_imports();
  __wbg_init_memory(imports);
  if (!(module instanceof WebAssembly.Module)) {
    module = new WebAssembly.Module(module);
  }
  const instance = new WebAssembly.Instance(module, imports);
  return __wbg_finalize_init(instance, module);
}
async function __wbg_init(module_or_path) {
  if (wasm !== void 0) return wasm;
  if (typeof module_or_path !== "undefined") {
    if (Object.getPrototypeOf(module_or_path) === Object.prototype) {
      ({ module_or_path } = module_or_path);
    } else {
      console.warn("using deprecated parameters for the initialization function; pass a single object instead");
    }
  }
  const imports = __wbg_get_imports();
  if (typeof module_or_path === "string" || typeof Request === "function" && module_or_path instanceof Request || typeof URL === "function" && module_or_path instanceof URL) {
    module_or_path = fetch(module_or_path);
  }
  __wbg_init_memory(imports);
  const { instance, module } = await __wbg_load(await module_or_path, imports);
  return __wbg_finalize_init(instance, module);
}
var pmg_mobile_quarantine_ui_default = __wbg_init;
export {
  pmg_mobile_quarantine_ui_default as default,
  initSync
};
