# This will avoid user defined aliases and possibly stuff defined earlier in the PATH.
# Redirecting is for the case when the binary is missing.
set vim_cond (command -v vim)
set vi_cond (command -v vi)

switch "$vim_cond-$vi_cond"
  case /usr/bin/vim-/usr/bin/vi
      # apply only if founded vim and vi are in the expected dir from distro
      function vi
        command vim $argv
      end

      function view
        command vim -R $argv
      end
  case -/usr/bin/vi
      # apply only when no vim is installed and founded vi is in the expected dir from distro
      function vim
        command read -p 'No vim found, using vi, press ENTER to continue' -n1 -t 20 -s && vi $argv
      end
end

# just in case
set -e vim_cond
set -e vi_cond
